// 2003/03/18 Support.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Collections;
using System.Windows.Forms;
using System.IO;
using System.Drawing;

namespace NTF.HXD.DOC
{
	/// <summary>
	///ݒ郆[eBeB\bh̊񂹏W
	/// </summary>
	public class Support
	{
		public Support()
		{
		}

		/// <summary>
		/// ݒ̕f[^̓͂B
		/// </summary>
		static public string ProcessQuote(string s)
		{
			string temp = s.Replace("\"" , string.Empty );
			temp = temp.Replace(";" , "-" );
			return temp;
		}

		/// <summary>
		/// pt,Xg܂B
		/// </summary>
		/// <param name="s">镶</param>
		/// <returns>̕</returns>
		static public string[] ProcessQuoteArray(string s)
		{
			string[] temp = s.Split(',');

			return RemoveBrank( temp );
		}

		/// <summary>
		/// ArrayListString[]֕ϊ
		/// </summary>
		/// <param name="list">ArrayList</param>
		/// <returns>String[]</returns>
		static public string[] ListToStrings(ArrayList list)
		{
			if( list == null || list.Count == 0 )
			{
				return null;
			}

			string[] temp = new string[list.Count];
			for(int i = 0 ; i < list.Count  ; i++ )
			{
				temp[i] = (string)list[i];
			}
			return temp;
		}

		/// <summary>
		/// Windows̃pX؂linux̃pX؂ɂB
		/// </summary>
		/// <param name="path">pX</param>
		/// <returns>̃pX</returns>
		static public string WinPathToLinux(string path)
		{
			return path.Replace("\\" , "/" );
		}

		/// <summary>
		/// z񂩂󕶎ĕԂB(string.Split()󕶎Ԃ߁j
		/// </summary>
		/// <param name="s">镶̔z</param>
		/// <returns>̔̕z</returns>
		static public string[] RemoveBrank(string[] s)
		{
			if( s == null)
			{
				return null;
			}
																
			ArrayList array = new ArrayList();

			for(int i = 0 ; i < s.Length  ; i++ )
			{
				if( !s[i].Equals( string.Empty ) )
				{
					array.Add( s[i] );
				}
			}
			return ListToStrings( array );
		}

		/// <summary>
		/// Array.BinarySearchgȂɎgpB
		/// </summary>
		/// <param name="s">z</param>
		/// <param name="match">TeLXg</param>
		/// <returns>z̃CfbNXBȂꍇ-1</returns>
		/// <remarks>
		/// 啶͋ʂȂB
		/// </remarks>
		public static int SearchText(string[] s ,string match)
		{
			if( s == null )
			{
				return -1;
			}

			int index = -1;
			for(int i = 0 ; i < s.Length  ; i++ )
			{
				if( s[i].ToLower().Equals( match.ToLower() ))
				{
					index = i;
					break;
				}
			}

			return index;
		}

		/// <summary>
		/// eLXg{bNX̑I͈͂̃eLXgۑB
		/// </summary>
		/// <param name="textBox">gpeLXg{bNX</param>
		static public void SaveSelectedText(TextBoxBase textBox)
		{
			if( textBox.SelectionLength < 1 )
			{
				return;
			}

			SaveFileDialog saveFileDialog1 = new SaveFileDialog();
			saveFileDialog1.Filter = "txt files (*.txt)|*.txt";
			saveFileDialog1.FilterIndex = 1;
			saveFileDialog1.DefaultExt = "txt files | *.txt";
			saveFileDialog1.RestoreDirectory = true;
 
			if(saveFileDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK &&
				saveFileDialog1.FileName.Length > 0) 
			{
				try
				{
					using(
						StreamWriter writer = new StreamWriter(saveFileDialog1.FileName ,
							false,System.Text.Encoding.Default)
							)
					{

						writer.Write(textBox.SelectedText);
						writer.Flush();

					}
				}
				catch
				{
	
					MessageBox.Show ( "t@C݂Ɏs܂B" , "G[",
						MessageBoxButtons.OK, MessageBoxIcon.Error);

				}
			}
		}

	}
}
